//
// Pivot Helper.js
//
//
//  (c) 2014 Hiroto Tsubaki
//  http://www.tres-graficos.jp/
//  tg@tres-graficos.jp
//
// Usage: Place this into ~/Library/Application Support/Cheetah3D/scripts/Tool folder. restart Cheetah3D, then select from Tools -> Scritp -> Tool Script
//


function buildUI( tool ) {
    tool.addParameterSeparator("Pivot Helper");
    
    tool.addParameterSelector("mode", ["only selected", "recursive", "all"], false, false);
    
    tool.addParameterButton("center pivot","set","setCenterPivot");
    tool.addParameterButton("reset pivot","set","resetPivot");
    tool.addParameterButton("freeze pivot","set","freezePivot");
    
}

function setCenterPivot( tool ) {
  
  var mode = tool.getParameter("mode");
  var recursive = false;
  var obj;
  
  if (mode == 0) {
    obj = tool.document().selectedObject();
  } else if (mode == 1) {
    obj = tool.document().selectedObject();
    recursive = true;
  } else if (mode == 2) {
    obj = tool.document().root();
    recursive = true;
  }
  
  makeCenterPivot( obj, recursive );
}

function makeCenterPivot( obj, recursive ) {
  if (obj && recursive) {
    for( var i = 0;i < obj.childCount();i++) {
      makeCenterPivot( obj.childAtIndex( i ) );
    }
  }
  
  if (obj.family() == NGONFAMILY) {
    
    var core = obj.core();
    var vertexCount = core.vertexCount();
    
    var max = core.vertex(0);
    var min = max.copy();
    
    for (var j = 1;j < vertexCount;j++) {
      var vec = core.vertex(j);
      
      max.x = Math.max( vec.x, max.x );
      max.y = Math.max( vec.y, max.y );
      max.z = Math.max( vec.z, max.z );
      
      min.x = Math.min( vec.x, min.x );
      min.y = Math.min( vec.y, min.y );
      min.z = Math.min( vec.z, min.z );
    }
    
    var center = max.add( min ).multiply( 1 / 2 );
    
    obj.recordParametersForUndo();
    obj.setParameter("pivot", center);
  }
}

function resetPivot( tool ) {
  var mode = tool.getParameter("mode");
  var recursive = false;
  var obj;
  
  if (mode == 0) {
    obj = tool.document().selectedObject();
  } else if (mode == 1) {
    obj = tool.document().selectedObject();
    recursive = true;
  } else if (mode == 2) {
    obj = tool.document().root();
    recursive = true;
  }
  
  
  makeResetPivot( obj, recursive );
}

function makeResetPivot( obj, recursive ) {
  if (obj && recursive) {
    for( var i = 0;i < obj.childCount();i++) {
      makeResetPivot( obj.childAtIndex( i ) );
    }
  }
  
  obj.recordParametersForUndo();
  obj.setParameter("pivot", new Vec3D());
}

function freezePivot( tool ) {
  var mode = tool.getParameter("mode");
  var recursive = false;
  var obj;
  
  if (mode == 0) {
    obj = tool.document().selectedObject();
  } else if (mode == 1) {
    obj = tool.document().selectedObject();
    recursive = true;
  } else if (mode == 2) {
    obj = tool.document().root();
    recursive = true;
  }
  
  
  makeFreezePivot( obj, recursive );
}

function makeFreezePivot( obj, recursive ) {
  if (obj && recursive) {
    for( var i = 0;i < obj.childCount();i++) {
      makeFreezePivot( obj.childAtIndex( i ) );
    }
  }
  
  if (obj.type() == POLYGONOBJ) {
    
    var pivot = obj.getParameter("pivot");
    
    var mat = new Mat4D(TRANSLATE, pivot.x, pivot.y, pivot.z);
    mat = mat.inverse();
    
    obj.recordGeometryForUndo();
    
    var core = obj.core();
    var vertexCount = core.vertexCount();
    
    for (var j = 0;j < vertexCount;j++) {
      var vec = core.vertex(j);
      core.setVertex( j, mat.multiply( vec ) );
    }
    
    obj.recordParametersForUndo();
    
    obj.setParameter("pivot", new Vec3D());
    
    var pos = obj.getParameter("position");
    
    obj.setParameter("position", pos.add(pivot));
    
    obj.update();
  }
}
